################################################################
###  Code for iAs meta-analyses - adapted from PFAS code written by Alex Lee #####

#### Set working directory and load libaries

setwd("C:/Users/adavis10/OneDrive - Environmental Protection Agency (EPA)/adavis10/IRIS/arsenic/DoseResponse for IASD/pregnancy_neuro_RfD")

library(readxl)
library(tidyverse)
library(metafor)
library(meta)
library(knitr)
library(kableExtra)
library(RColorBrewer)
library(ggthemes)
source("utility_functions.R")

### read in data file, do this either for birth weight or neurodev betas file

betas<-read.csv("iAs_neuro_betas_SP_WPPSI_all_nrml_betas.csv")
attach(betas)

### Meta-analysis code - using metafor library

### birth weight data
rma_overall <- rma(yi = BetaNrml2, sei = BetaNrmlSE2, data = betas)
print_results("Overall", rma_overall, betas) %>% kable(format = 'pandoc')

### neurodev data
rma_neuro <- rma(yi = BetaNrml1, sei = BetaNrmlSE1, data = betas)
print_results("Overall", rma_neuro, betas,) %>% kable(format = 'pandoc')

###forest plot for birth weight
plot_df <- betas %>%
  mutate(SampleTiming = factor(fct_recode(Bin2, `1st` = "T1", `2nd` = "T2",`1st-3rd` = "T1-T3", `3rd` = "T3", `Post-natal` = "PN"), levels = c( "1st", "2nd", "1st-3rd", "3rd", "Post-natal")),
         Confidence = factor(Confidence, levels = c("High", "Medium", "Low")))

# mutate(SampleTiming = factor(SampleTiming2, levels = c("1st", "2nd", "3rd", "AVerage 1st-3rd", "Post-natal")),
#     Confidence = factor(Confidence, levels = c("High", "Medium", "Low")))
#levels(plot_df$SampleTiming) <- c("Pre-Conception", "1st", "1st-2nd", "2nd-3rd", "3rd", "Birth", "Post-Birth")

# TODO manipulate column positions and rename Timing to `Sample Timing`

## forest plot for birth weight
forest(rma_overall,
       at=seq(-30,30,by=10),
       cex = .55,
       level = 95,
       digits = 2L,
       xlim = c(-120, 60),
       alim = c(-30, 30),
       order = order(plot_df$Confidence, plot_df$SampleTiming, plot_df$Sample.Size),
       header = "Study",
       ilab = cbind(as.character(plot_df$Confidence),
                    as.character(plot_df$SampleTiming),
                    plot_df$Sample.Size),
       ilab.xpos = c(-70, -55, -40),
       slab = plot_df$Study,
       xlab = "Change in birth weight per ug/L maternal urinary tAs",
       mlab = modify_label(rma_overall, "All Studies, RE Model"))
p <- par(cex = .55, font=2)
text(c(-70, -55, -40), length("Study")+7, c("Confidence", "Timing", "N"))

###forest plot for neurodev
plot_df <- betas %>%
  mutate(SampleTiming = factor(fct_recode(Bin, `1st` = "T1", `2nd` = "T2",`1st-3rd` = "T1-T3", `3rd` = "T3", `Post-natal` = "PN"), levels = c( "1st", "2nd", "1st-3rd", "3rd", "Post-natal")),
         Confidence = factor(Confidence, levels = c("High", "Medium", "Low")))

##forest plot for IQ
forest(rma_neuro,
       at=seq(-6,2,by=2),
       cex = .55,
       level = 95,
       digits = 2L,
       xlim = c(-30, 10),
       alim = c(-6, 2),
       order = order(plot_df$Confidence, plot_df$SampleTiming, plot_df$Sample.Size),
       header = "Study",
       ilab = cbind(as.character(plot_df$Confidence),
                    as.character(plot_df$SampleTiming),
                    plot_df$Sample.Size),
       ilab.xpos = c(-18, -13, -8),
       slab = plot_df$Study,
       xlab = "IQ change (points) per log2(ug/L) maternal urinary tAS",
       mlab = modify_label(rma_neuro, "All Studies, RE Model"))
p <- par(cex = .55, font=2)
text(c(-18, -13, -8), length("Study")+4, c("Confidence", "Timing", "N"))

### leave one out analysis
loo <- leave1out(rma_overall, digits = 2) %>% 
  as.data.frame() %>%
  mutate_at(c(1:3, 5:11), ~round(., 2)) %>%
  mutate_at(c(4), ~round(., 5)) %>%
  add_column(Study, .before = "estimate")
ind <- which(loo$I2 == min(loo$I2))

###publication bias
regtest_out <- regtest(rma_neuro, model = "rma", predictor = "sei")
regtest_p <- round(regtest_out$pval, 4)

### funnel plot
funnel(rma_neuro, xlab = sprintf("Effect Estimate of maternal urinary tAs on IQ Scores")) # label = 3)